<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ComponentModel extends Model 
{

    protected $table = 'components_models';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function make()
    {
        return $this->belongsTo('Make');
    }

    public function components()
    {
        return $this->hasMany('Component');
    }

}